package gov.va.med.mhv.integration.phr.service.via;

import gov.va.med.mhv.integration.phr.stage.transfer.StageWellnessReminder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Scanner;

/**
 * Author: Rob Murtha
 * Suggested rules for the 'screen scraping' approach.

Fields will be trimmed of spaces as they are copied and stored.
If column 1 contains a non space character then it is a title line and the beginning of a new reminder.
The reminder description field appears at columns 1 - 36
 The title of the Subject must match a list provided
If N/A appears at column 40 there are no other fields
the status field is located at columns 37 - 46
the due date field is located at columns 48 - 59
the last done field is located at columns 62 - 74
the lines following a title up to the next title or the end contain the details
Web Site: indicates the beginning of a website description
URL: indicates the beginning of a url which may be on the same or next line
*** END indicates the end of the reminders
all database columns would be text characters, no date parsing
the location would be the facility name where the reminder was retrieved

 */
public class ReminderSplitter {
    private Scanner scanner;
    private int lineCount=0;
    private String line;
    private List<String> titles = null;
    private Hashtable<String,String> titleHash;


    public ReminderSplitter() {
        if(titles==null)
            titles=getTitles();
        if(titles==null||titles.size()==0) {
            throw new IllegalArgumentException("list of titles must not be empty");
        }
    }


    public ReminderSplitter(List<String> titles) {
        this.titles = titles;
        if(titles==null||titles.size()==0) {
            throw new IllegalArgumentException("list of titles must not be empty");
        }
    }

    public List<StageWellnessReminder> split(String fullSummary) {
        List<StageWellnessReminder> result = new ArrayList<StageWellnessReminder>();
        scanner = new Scanner(fullSummary);
        //scanner.useDelimiter(System.getProperty("line.separator"));
        scanner.useDelimiter("\n");

        skipHeader();
        while(scanner.hasNext() && !isEnd()) {
            StageWellnessReminder reminder = getNextReminder();
            if(reminder!=null)
                result.add(reminder);
        }

        return result;
    }

    private void skipHeader() {
        // skip first 7 lines of the report
        while(scanner.hasNext() && lineCount++ < 5) {
            line=scanner.nextLine();
        }

        while(scanner.hasNext() && !isStart()) {
            line=scanner.nextLine();
        }
    }

    /** returns true if the next line is the start of a new reminder */
    private boolean isStart() {
        boolean value = line!=null && line.length() >0 && line.substring(0,1).matches("^[A-Z]");
        return value;
    }

    private boolean isEnd() {
        boolean value = line.indexOf("*** END")==0;
        return value;
    }

    public String matchTitle(String line) {
        String result=null;
        for(String title:titles) {
            if(line.startsWith(title)) {
                result=title;
                break;
            }
        }
        return result;
    }

    /** parse the body returning reminders with a status, otherwise null */
    private StageWellnessReminder getNextReminder() {

        StageWellnessReminder current = null;
        StringBuffer summary = null;

        /** process records with a status other than N/A */
        if(!line.contains("N/A")) {
            String title = matchTitle(line);
            if(title!=null) {
                current = new StageWellnessReminder();
                summary = new StringBuffer();

                current.setExtractDate(new Date());
                current.setSubject(title);

                /** records with status other than N/A have three fields, otherwise there are no date fields */
                current.setWellnessStatus(line.substring(37,46).trim().toUpperCase());
                String dueNow = line.substring(48,59).trim().toUpperCase();
                if(!dueNow.equals("DUE NOW")) {
                	current.setDueDateImprecise(line.substring(48,59).trim().toUpperCase());
                } else if (dueNow.equals("DUE NOW")){
                	current.setDueDateImprecise(dueNow);
                } else {
                	current.setDueDateImprecise("");
                }
                
                String dateLastDone = line.substring(62,line.length()).trim().toUpperCase();
                if(!dateLastDone.equals("UNKNOWN")) {
                	current.setDateLastDoneImprecise(line.substring(62,line.length()).trim().toUpperCase());
                } else if (dateLastDone.equals("UNKNOWN")){
                	current.setDateLastDoneImprecise(dateLastDone);
                } else {
                	current.setDateLastDoneImprecise("");
                }
                while(scanner.hasNextLine()) {
                    line=scanner.nextLine();
                    if( isStart() || isEnd()) {
                        break;
                    } else {
                        summary.append(line).append('\n');
                    }
                }
                current.setFullSummary(summary.toString());
            } else {
                while(scanner.hasNextLine()) {
                    line=scanner.nextLine();
                    if( isStart() || isEnd()) {
                        break;
                    }
                }
            }
        } else {
            while(scanner.hasNextLine()) {
                line=scanner.nextLine();
                if( isStart() || isEnd()) {
                    break;
                }
            }
        }
        return current;
    }

    public List<String> getTitles() {
        final String titles[] = {"Body Mass Index more than 25",
                          "FYI-More Personal Wellness Info",
                          "Body Mass Index >25",
                          "Colon Cancer Screening",
                          "Control of Your Cholesterol",
                          "Eye Exam for Diabetes",
                          "Foot Exam for Diabetes",
                          "HbA1c for Diabetes",
                          "Hypertension (High Blood Pressure)",
                          "Influenza Vaccine",
                          "Lipid Measurement (Cholesterol)",
                          "Mammogram Screening",
                          "PAP Smear Screening",
                          "Pneumonia Vaccine"};

          return new ArrayList<String>(Arrays.asList(titles));
        }

    public void setTitles(List<String> titles) {
        this.titles=titles;
    }
}
